# R script for Figure 1C
# For drawing the graph, ggplot2 should be installed.

names = factor(rep(c("1:mt", "2:mt+dmso", "3:mt+10", "4:mt+30", "5:mt+100", "6:mt+db10", "7:mt+db100"), c(3, 3, 3, 3, 3, 3, 3)))
PercentControl = c(900.3333333, 822.3333333, 737.3333333, 778.3333333, 783.3333333, 836.3333333, 673.3333333, 711.3333333, 559.3333333, 632.3333333, 732.3333333, 555.3333333, 462.3333333, 617.3333333, 547.3333333, 340.3333333, 513.3333333, 12.33333333, 208.3333333, 135.3333333, -35.66666667)
data=data.frame(names, PercentControl)
anova(aov(PercentControl ~ names))
TukeyHSD(aov(PercentControl ~ names))
mean <- aggregate(PercentControl ~ names, data, mean)
sd <- aggregate(PercentControl ~ names, data, sd)

library(ggplot2)
i <- ggplot(data, aes(y = PercentControl, x = factor(names), colour = factor(names), fill = factor(names), group = factor(names))) + theme_classic()
i <- i + stat_summary(fun.y = "mean", geom = "bar",  width = 0.5, fill = "grey", position = "dodge", colour="black")
i <- i + stat_summary(fun.y = "mean", fun.ymin = function(x)mean(x)-sd(x), fun.ymax = function(x)mean(x) + sd(x), geom = "errorbar", position = position_dodge(width = 0), width = 0.2, colour="black")
i <- i + geom_point(position = position_jitterdodge(jitter.width = 1, jitter.height = 0, dodge.width = .6), colour="red", size = 3)
i <- i + theme_classic() 
i <- i + scale_y_continuous(expand = c(0, 0), limits = c(-500,1000)) 
i <- i + theme(axis.title.x = element_text(size=10, family = "Arial"), axis.title.y = element_text(size=10, family = "Arial"), axis.text.x = element_text(size=10, colour = 1, family = "Arial"), axis.text.y = element_text(size = 10, colour = 1, family = "Arial"))
png("plot2.png", width = 600, height = 300)
i
dev.off() 
